sampler texture0 : register(s0);
sampler texture1 : register(s1);

float4x4 WorldViewProjectionTransform  : WORLDVIEWPROJ;
float2 fTextureSize;

struct VS_OUTPUT 
{
   float4 Position  : POSITION;
   float2 TexCoord  : TEXCOORD0;
};

struct PS_OUTPUT
{
    float4 RGBColor : COLOR0;  // Pixel color    
};

VS_OUTPUT vertexMain(
				float4 vPosition : POSITION,
				float2 texCoord : TEXCOORD0)
{
	VS_OUTPUT Output; 

	Output.Position = mul(vPosition, WorldViewProjectionTransform);
	Output.TexCoord = texCoord;
	return Output;
}

PS_OUTPUT pixelMain(VS_OUTPUT In)
{
	float2 coord = In.TexCoord + 1.f / fTextureSize / 2.f;

	float4 px0 = tex2D(texture0, coord);
	float4 px1 = tex2D(texture1, coord);

	float4 result = saturate(lerp(px0, px1, px1.a));

	PS_OUTPUT output;
	output.RGBColor = result;
	//output.RGBColor.r = 1.f;
	output.RGBColor.a = 1.f;
	//output.RGBColor.r = px1.a;
	//output.RGBColor.g = px1.a;
	//output.RGBColor.b = 0.f;
	return output;
}